﻿namespace Code6587EN.Ch05.NewPublishingSite
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Administration;
    using System;

    /// <summary>
    /// Console Application to create a new SharePoint Publishing Site
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Open the Site Collection that will contain the new Publishing Site
            using (var site = new SPSite("http://sharepoint/"))
            {
                // Add the Publishing Site to the Site Collection
                site.AllWebs.Add("publishing", "Publishing Site", "A site about publishing.", (uint) site.RootWeb.Locale.LCID, "CMSPUBLISHING#0", true, false);
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
